/*
 * Decompiled with CFR 0.152.
 */
package dev.onyxstudios.cca.internal.block;

import dev.onyxstudios.cca.api.v3.block.BlockComponentFactoryRegistry;
import dev.onyxstudios.cca.api.v3.block.BlockComponentInitializer;
import dev.onyxstudios.cca.api.v3.component.Component;
import dev.onyxstudios.cca.api.v3.component.ComponentContainer;
import dev.onyxstudios.cca.api.v3.component.ComponentFactory;
import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.tick.ClientTickingComponent;
import dev.onyxstudios.cca.api.v3.component.tick.ServerTickingComponent;
import dev.onyxstudios.cca.internal.base.LazyDispatcher;
import dev.onyxstudios.cca.internal.base.QualifiedComponentFactory;
import dev.onyxstudios.cca.internal.base.asm.StaticComponentLoadingException;
import dev.onyxstudios.cca.internal.base.asm.StaticComponentPluginBase;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1937;
import net.minecraft.class_2586;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class StaticBlockComponentPlugin
extends LazyDispatcher
implements BlockComponentFactoryRegistry {
    public static final StaticBlockComponentPlugin INSTANCE = new StaticBlockComponentPlugin();
    private final List<PredicatedComponentFactory<?>> dynamicFactories = new ArrayList();
    private final Map<Class<? extends class_2586>, Map<ComponentKey<?>, QualifiedComponentFactory<ComponentFactory<? extends class_2586, ?>>>> beComponentFactories = new Reference2ObjectOpenHashMap();
    @VisibleForTesting
    public final Set<Class<? extends class_2586>> clientTicking = new ReferenceOpenHashSet();
    @VisibleForTesting
    public final Set<Class<? extends class_2586>> serverTicking = new ReferenceOpenHashSet();

    private static String getSuffix(Class<? extends class_2586> key) {
        return "BlockEntityImpl_%s_%s".formatted(key.getSimpleName(), Integer.toHexString(key.getName().hashCode()));
    }

    private StaticBlockComponentPlugin() {
        super("creating a BlockEntity");
    }

    @Nullable
    public <T extends class_2586> class_5558<T> getComponentTicker(class_1937 world, T be, @Nullable class_5558<T> base) {
        if (world.field_9236 && this.clientTicking.contains(be.getClass())) {
            if (base == null) {
                return (w, pos, state, blockEntity) -> blockEntity.asComponentProvider().getComponentContainer().tickClientComponents();
            }
            return (w, pos, state, blockEntity) -> {
                blockEntity.asComponentProvider().getComponentContainer().tickClientComponents();
                base.tick(w, pos, state, blockEntity);
            };
        }
        if (!world.field_9236 && this.serverTicking.contains(be.getClass())) {
            if (base == null) {
                return (w, pos, state, blockEntity) -> blockEntity.asComponentProvider().getComponentContainer().tickServerComponents();
            }
            return (w, pos, state, blockEntity) -> {
                blockEntity.asComponentProvider().getComponentContainer().tickServerComponents();
                base.tick(w, pos, state, blockEntity);
            };
        }
        return base;
    }

    public boolean requiresStaticFactory(Class<? extends class_2586> entityClass) {
        INSTANCE.ensureInitialized();
        for (PredicatedComponentFactory<?> dynamicFactory : this.dynamicFactories) {
            dynamicFactory.tryRegister(entityClass);
        }
        return entityClass == class_2586.class || this.beComponentFactories.containsKey(entityClass);
    }

    public ComponentContainer.Factory<class_2586> buildDedicatedFactory(Class<? extends class_2586> entityClass) {
        INSTANCE.ensureInitialized();
        LinkedHashMap<ComponentKey, QualifiedComponentFactory> compiled = new LinkedHashMap<ComponentKey, QualifiedComponentFactory>(this.beComponentFactories.getOrDefault(entityClass, Map.of()));
        Class<? extends class_2586> type = entityClass;
        while (type != class_2586.class) {
            type = type.getSuperclass().asSubclass(class_2586.class);
            for (Map.Entry e : this.beComponentFactories.getOrDefault(type, Map.of()).entrySet()) {
                compiled.putIfAbsent((ComponentKey)e.getKey(), (QualifiedComponentFactory)e.getValue());
            }
        }
        ComponentContainer.Factory.Builder builder = ComponentContainer.Factory.builder(class_2586.class).factoryNameSuffix(StaticBlockComponentPlugin.getSuffix(entityClass));
        for (Map.Entry<ComponentKey<?>, QualifiedComponentFactory<ComponentFactory<class_2586, ?>>> entry : compiled.entrySet()) {
            this.addToBuilder((ComponentContainer.Factory.Builder<class_2586>)builder, entry);
            if (ClientTickingComponent.class.isAssignableFrom(entry.getValue().impl())) {
                this.clientTicking.add(entityClass);
            }
            if (!ServerTickingComponent.class.isAssignableFrom(entry.getValue().impl())) continue;
            this.serverTicking.add(entityClass);
        }
        return builder.build();
    }

    public void registerTickersFor(Class<? extends class_2586> entityClass, Class<? extends class_2586> parentClass) {
        if (this.clientTicking.contains(parentClass)) {
            this.clientTicking.add(entityClass);
        }
        if (this.serverTicking.contains(parentClass)) {
            this.serverTicking.add(entityClass);
        }
    }

    private <C extends Component> void addToBuilder(ComponentContainer.Factory.Builder<class_2586> builder, Map.Entry<ComponentKey<?>, QualifiedComponentFactory<ComponentFactory<? extends class_2586, ?>>> entry) {
        ComponentKey<?> key = entry.getKey();
        ComponentFactory factory = (ComponentFactory)entry.getValue().factory();
        Class impl = entry.getValue().impl();
        builder.component(key, impl, factory, entry.getValue().dependencies());
    }

    public <C extends Component, E extends class_2586> void registerFor(Class<E> target, ComponentKey<C> type, ComponentFactory<E, C> factory) {
        this.checkLoading(BlockComponentFactoryRegistry.class, "register");
        this.register0(target, type, new QualifiedComponentFactory(factory, type.getComponentClass(), Set.of()));
    }

    private <C extends Component, F extends C, E extends class_2586> void register0(Class<? extends E> target, ComponentKey<? super C> type, QualifiedComponentFactory<ComponentFactory<E, F>> factory) {
        Map specializedMap = this.beComponentFactories.computeIfAbsent(target, t -> new LinkedHashMap());
        QualifiedComponentFactory previousFactory = (QualifiedComponentFactory)specializedMap.get(type);
        if (previousFactory != null) {
            throw new StaticComponentLoadingException("Duplicate factory declarations for %s on %s: %s and %s".formatted(type.getId(), target, factory, previousFactory));
        }
        QualifiedComponentFactory<ComponentFactory<E, F>> factory1 = factory;
        specializedMap.put(type, factory1);
    }

    @Override
    public <C extends Component, B extends class_2586> BlockComponentFactoryRegistry.Registration<C, B> beginRegistration(Class<B> target, ComponentKey<C> key) {
        return new RegistrationImpl<C, B>(target, key);
    }

    protected void init() {
        StaticComponentPluginBase.processInitializers((Collection)StaticComponentPluginBase.getComponentEntrypoints((String)"cardinal-components-block", BlockComponentInitializer.class), initializer -> initializer.registerBlockComponentFactories(this));
    }

    private final class PredicatedComponentFactory<C extends Component> {
        private final Predicate<Class<? extends class_2586>> predicate;
        private final ComponentKey<? super C> type;
        private final QualifiedComponentFactory<ComponentFactory<class_2586, C>> factory;

        public PredicatedComponentFactory(Predicate<Class<? extends class_2586>> predicate, ComponentKey<? super C> type, QualifiedComponentFactory<ComponentFactory<class_2586, C>> factory) {
            this.type = type;
            this.factory = factory;
            this.predicate = predicate;
        }

        public void tryRegister(Class<? extends class_2586> clazz) {
            if (this.predicate.test(clazz)) {
                StaticBlockComponentPlugin.this.register0(clazz, this.type, this.factory);
            }
        }
    }

    private final class RegistrationImpl<C extends Component, E extends class_2586>
    implements BlockComponentFactoryRegistry.Registration<C, E> {
        private final Class<E> target;
        private final ComponentKey<? super C> key;
        private final Set<ComponentKey<?>> dependencies;
        private Class<C> componentClass;
        private Predicate<Class<? extends E>> test;

        RegistrationImpl(Class<E> target, ComponentKey<C> key) {
            this.target = target;
            this.componentClass = key.getComponentClass();
            this.dependencies = new LinkedHashSet();
            this.test = null;
            this.key = key;
        }

        @Override
        public BlockComponentFactoryRegistry.Registration<C, E> filter(Predicate<Class<? extends E>> test) {
            this.test = this.test == null ? test : this.test.and(test);
            return this;
        }

        @Override
        public BlockComponentFactoryRegistry.Registration<C, E> after(ComponentKey<?> dependency) {
            this.dependencies.add(dependency);
            return this;
        }

        @Override
        public <I extends C> BlockComponentFactoryRegistry.Registration<I, E> impl(Class<I> impl) {
            RegistrationImpl ret = this;
            ret.componentClass = impl;
            return ret;
        }

        @Override
        public void end(ComponentFactory<E, C> factory) {
            StaticBlockComponentPlugin.this.checkLoading(BlockComponentFactoryRegistry.Registration.class, "end");
            if (this.test == null) {
                StaticBlockComponentPlugin.this.register0(this.target, this.key, new QualifiedComponentFactory(factory, this.componentClass, this.dependencies));
            } else {
                StaticBlockComponentPlugin.this.dynamicFactories.add(new PredicatedComponentFactory<C>(c -> this.target.isAssignableFrom((Class<?>)c) && this.test.test(c.asSubclass(this.target)), this.key, new QualifiedComponentFactory(entity -> factory.createComponent((Object)((class_2586)this.target.cast(entity))), this.componentClass, this.dependencies)));
            }
        }
    }
}

